<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Sewing Gantt Chart - Exact Match</title>

  <script src="https://cdn.tailwindcss.com"></script>
  <link rel="stylesheet" href="https://code.jquery.com/ui/1.13.2/themes/base/jquery-ui.css">
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.6.0/css/all.min.css" integrity="sha512-KWCOgQYJr0X1Vj5ibFJ7v5uDpH0SPWTxR0LJ8Ux7EfrUt9i8ek6FZvvJ3E/4Nn2/XL5e5Qkr6dJG12lqNfq9Wg==" crossorigin="anonymous" referrerpolicy="no-referrer" />


  <style>
    .day-cell { min-width: 32px; width: 32px; }
    .task-bar {
      /* Tailwind @apply does not run in-browser via CDN, so set explicit styles */
      position: absolute;
      height: 40px;
      background-color: #f97316; /* orange-500 */
      color: #ffffff;
      font-size: 0.75rem;
      font-weight: 500;
      border-radius: 0.5rem;
      box-shadow: 0 4px 6px rgba(0, 0, 0, 0.1);
      cursor: move;
      display: flex;
      align-items: center;
      justify-content: center;
      border: 2px solid #ffffff;
      top: 50%;
      transform: translateY(-50%);
      padding: 0 12px;
      white-space: nowrap;
      z-index: 10;
    }

    .task-bar:hover { 
      box-shadow: 0 0 0 4px #feb2c6; /* ring-4 ring-orange-300 */
    }
    .task-layer {
        min-width: fit-content;
        width: max-content;
    }
    .task-layer {
    height: 40px !important;        /* reduced row height */
    }
    .task-bar {
    height: 30px !important;        /* reduced bar height */
    line-height: 40px;
    top: 50% !important;
    transform: translateY(-50%);
    }
  </style>
</head>
<body class="bg-gray-100">

    @include('LifeAtGainup.Planning.GUTplanning.Gutplan_nav')

<div class="h-screen flex flex-col ">

  <!-- Top Nav -->
  <div class="flex items-center justify-between px-6 py-3 border-b bg-white">
    <div class="flex gap-1 text-sm">
      <button class="process-btn px-4 py-1.5 text-gray-600" data-process="cutting">Cutting</button>
      <button class="process-btn px-4 py-1.5 text-gray-600" data-process="printing">Printing</button>
      <button class="process-btn px-4 py-1.5 text-gray-600" data-process="embroidery">Embroidery</button>
      <button class="process-btn px-4 py-1.5 bg-gray-200 text-gray-800 rounded" data-process="sewing">Sewing</button>
      <button class="process-btn px-4 py-1.5 text-gray-600" data-process="packing">Packing</button>
      <button class="process-btn px-4 py-1.5 text-gray-600" data-process="pab-mode">PAB Mode</button>
    </div>
    <div class="flex items-center gap-4">
      <!-- Year Navigation -->
      <div class="flex items-center gap-2 hidden">
        <button id="prev-year" class="px-3 py-1 bg-gray-100 hover:bg-gray-200 rounded text-sm font-medium">←</button>
        <span id="current-year" class="px-4 py-1 bg-blue-100 text-blue-700 rounded text-sm font-bold">2026</span>
        <button id="next-year" class="px-3 py-1 bg-gray-100 hover:bg-gray-200 rounded text-sm font-medium">→</button>
      </div>
      <div class="flex gap-2">
        <button class="px-4 py-1.5 bg-blue-100 text-blue-700 rounded text-sm font-medium">Day View</button>
        <button class="px-4 py-1.5 text-gray-600 text-sm">Hour View</button>
      </div>
    </div>
  </div>

  <!-- Main Grid -->
  <div class="flex flex-1 overflow-hidden">

    <!-- Left: Unplanned -->
    <div class="w-80  border-r p-4">
      <div class="bg-white rounded-lg shadow-sm border h-full p-6 text-center">
        <h3 class="font-semibold text-lg mb-2">Unplanned</h3>
        <p id="unplanned-text" class="text-sm text-gray-500 mb-5">All Sewing processes are scheduled.</p>
        <div id="small-cards-container">
          <!-- Small cards will be generated dynamically based on process -->
        </div>
      </div>
    </div>
 
        <!-- Right: Gantt Chart -->
        <div class="flex-1 flex flex-col bg-white shadow-md rounded-lg p-6 mt-4" style="max-width: 80%;">
            <div class="overflow-x-auto">
                <!-- Fixed Header -->
                <div id="header-scroll" class="bg-white border-b z-20">
                    <div class="min-w-max">

                        <!-- Month Row -->
                        <div class="grid grid-cols-[200px_1fr] border-b">
                            <div class="border-r bg-gray-50 font-medium py-2 pl-4 sticky left-0 z-30" style="position: sticky;"> year</div>
                            <div class="flex" id="month-headers">
                            </div>
                        </div>

                        <!-- Week Row -->
                        <div class="grid grid-cols-[200px_1fr] text-xs text-gray-600 border-b">
                            <div class="py-2 pl-4 border-r bg-gray-50 font-medium sticky left-0 z-30" style="position: sticky;">Week</div>
                            <div class="flex" id="week-headers">
                            </div>
                        </div>

                        <!-- Day Row -->
                        <div class="grid grid-cols-[200px_1fr] text-xs text-gray-700 border-b bg-gray-50">
                            <div class="py-2 pl-4 border-r font-medium sticky left-0 z-30 bg-gray-50" style="position: sticky;">Day</div>
                            <div class="flex" id="day-headers"></div>
                        </div>
                    </div>
                </div>

                <!-- Scrollable Body -->
                <div id="gantt-body" class="flex-1 bg-white">
                        <div class="min-w-max" id="gantt-rows">
                        <!-- Gantt rows will be generated dynamically -->
                        </div>
                </div>
            </div>
        </div>

        <!-- Modal Background -->
        <div class="fixed inset-0 bg-black bg-opacity-40 flex items-center justify-center z-50" id="split-modal" style="display: none;">

            <!-- Popup Card -->
            <div class="bg-white w-[480px] rounded-lg shadow-xl p-6 border border-gray-200">

                <!-- Title -->
                <h2 class="text-xl font-semibold mb-1">Split Process: Cutting</h2>

                <!-- Subtitle -->
                <p class="text-gray-500 text-sm leading-5 mb-6">
                    For Order 114227-Green. Adjust the values for the total of 729.17 Days.
                    The sum must equal the total.
                </p>

                <!-- Batch Table -->
                <div class="grid grid-cols-2 mb-2 px-1">
                    <span class="text-gray-700 font-medium text-sm">Batch</span>
                    <span class="text-gray-700 font-medium text-sm">Days</span>
                </div>

                <!-- Batch 1 Row -->
                <div class="grid grid-cols-2 items-center mb-3 px-1 batch-row" data-batch="1">
                    <span class="text-gray-700 text-sm">Batch 1</span>

                    <input
                        type="number"
                        value="0"
                        class="border rounded-md px-3 py-2 text-sm focus:ring-1 focus:ring-blue-400 focus:border-blue-400 batch-input"
                    />
                </div>

                <!-- Remainder Row -->
                <div class="grid grid-cols-2 items-center mb-4 px-1">
                    <span class="text-gray-700 text-sm">Remainder</span>

                    <input
                        id="split-remainder"
                        type="text"
                        value="0"
                        disabled
                        class="border rounded-md px-3 py-2 text-sm bg-gray-100 text-gray-600"
                    />
                </div>

                <!-- Add Batch -->
                <button class="flex items-center gap-2 text-blue-600 text-sm mb-4 px-1" id="add-batch-btn">
                    <i class="fa-solid fa-plus text-blue-600"></i>
                    Add Batch
                </button>

                <!-- Divider -->
                <div class="border-t border-gray-300 my-4"></div>

                <!-- Totals -->
                <div class="flex justify-between text-sm mb-1 px-1">
                    <span class="text-gray-700 font-medium">Total Split Duration:</span>
                    <span id="split-total-entered" class="text-blue-600 font-semibold">0.00</span>
                </div>

                <div class="flex justify-between text-sm mb-6 px-1">
                    <span class="text-gray-700">Original Total:</span>
                    <span id="split-original-total" class="text-gray-700">0.00</span>
                </div>

                <!-- Footer Buttons -->
                <div class="flex justify-end gap-3">

                    <!-- Cancel -->
                    <button class="px-4 py-2 border border-gray-300 rounded-md text-sm hover:bg-gray-100" id="cancel-split">
                        Cancel
                    </button>

                    <!-- Confirm Split -->
                    <button id="confirm-split" class="px-5 py-2 bg-blue-500 text-white rounded-md text-sm hover:bg-blue-600 shadow-sm">
                        Confirm Split
                    </button>

                </div>

            </div>

        </div>

    
</div>

<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="https://code.jquery.com/ui/1.13.2/jquery-ui.min.js"></script>
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">

<script>
// Calendar configuration
let currentYear = 2026;
let startDate = new Date('2026-01-01');
  const dayWidth = 32;

function isLeapYear(year) {
  return (year % 4 === 0 && year % 100 !== 0) || year % 400 === 0;
}

function getDaysInYear(year) {
  return isLeapYear(year) ? 366 : 365;
}

function updateYear(year) {
  currentYear = year;
  startDate = new Date(`${year}-01-01`);
  $('#current-year').text(year);
  generateMonthHeaders();
  generateWeekHeaders();
  generateDayHeaders();
}

function getWeekNumber(date) {
  const firstDayOfYear = new Date(date.getFullYear(), 0, 1);
  const pastDaysOfYear = (date - firstDayOfYear) / 86400000;
  return Math.ceil((pastDaysOfYear + firstDayOfYear.getDay() + 1) / 7);
}

function generateMonthHeaders() {
  const $headers = $('#month-headers').empty();
  let currentMonth = '', monthDays = 0;
  for (let i = 0; i < getDaysInYear(currentYear); i++) {
    const date = new Date(startDate);
    date.setDate(date.getDate() + i);
    const monthName = date.toLocaleDateString('en-US', { month: 'short', year: '2-digit' });
    if (monthName !== currentMonth) {
      if (currentMonth) {
        const width = monthDays * dayWidth;
        $headers.append(`<div class="text-center py-3 font-semibold border-r bg-gray-50" style="width:${width}px">${currentMonth}</div>`);
      }
      currentMonth = monthName; monthDays = 1;
    } else monthDays++;
  }
  if (currentMonth) {
    const width = monthDays * dayWidth;
    $headers.append(`<div class="text-center py-3 font-semibold bg-gray-50" style="width:${width}px">${currentMonth}</div>`);
  }
}

function generateWeekHeaders() {
  const $headers = $('#week-headers').empty();
  let currentWeek = 0, weekDays = 0;
  for (let i = 0; i < getDaysInYear(currentYear); i++) {
    const date = new Date(startDate);
    date.setDate(date.getDate() + i);
    const weekNum = getWeekNumber(date);
    if (weekNum !== currentWeek) {
      if (currentWeek) {
        const width = weekDays * dayWidth;
        $headers.append(`<div class="text-center border-r py-2" style="width:${width}px">W${currentWeek}</div>`);
      }
      currentWeek = weekNum; weekDays = 1;
    } else weekDays++;
  }
  if (currentWeek) {
    const width = weekDays * dayWidth;
    $headers.append(`<div class="text-center py-2" style="width:${width}px">W${currentWeek}</div>`);
  }
}

function generateDayHeaders() {
  const $headers = $('#day-headers').empty();
  for (let i = 0; i < getDaysInYear(currentYear); i++) {
    const date = new Date(startDate);
    date.setDate(date.getDate() + i);
    const day = date.getDate();
    const isWeekend = date.getDay() === 0 || date.getDay() === 6;
    $headers.append(`<div class="day-cell text-center border-r py-1 text-xs ${isWeekend ? 'bg-gray-100' : ''}">${day}</div>`);
  }
}

$(document).ready(function() {
  let selectedTask = null;
  let splitTotalDays = 0;

  const processData = {
    cutting: { unplannedText: 'All Cutting processes are scheduled.', smallCards: [{ title: '114227', value: '12491', color: 'bg-blue-100 text-blue-800' },{ title: '114228', value: '12491', color: 'bg-green-100 text-green-800' }], stations: [{ name: 'Cutting Station 1', id: 'CT-1' }] },
    printing: { unplannedText: 'All Printing processes are scheduled.', smallCards: [{ title: '114229', value: '12491', color: 'bg-blue-100 text-blue-800' }], stations: [{ name: 'Printing Station 1', id: 'PR-1' }] },
    embroidery: { unplannedText: 'All Embroidery processes are scheduled.', smallCards: [{ title: '114230', value: '12491', color: 'bg-blue-100 text-blue-800' }], stations: [{ name: 'Embroidery Station 1', id: 'EM-1' }] },
    sewing: { unplannedText: 'All Sewing processes are scheduled.', smallCards: [{ title: '114231', value: '12491', color: 'bg-blue-100 text-blue-800' }], stations: [{ name: 'SLG-1', id: '114227' }] },
    packing: { unplannedText: 'All Packing processes are scheduled.', smallCards: [{ title: '114232', value: '12491', color: 'bg-blue-100 text-blue-800' }], stations: [{ name: 'Packing Station 1', id: 'PK-1' }] }
  };

  updateYear(currentYear);

  function renderSmallCards(processName) {

    $('#small-cards-container').empty();
    (processData[processName]?.smallCards || []).forEach(card => {
      $('#small-cards-container').append(`
        <div class="${card.color} rounded-lg p-3 mb-2 cursor-move small-card shadow hover:shadow-md" data-title="${card.title}" data-value="${card.value}" data-color="${card.color}">
          <div class="flex justify-between text-xs font-medium">
            <span>${card.title}</span>
            <span>Qty: <strong>${card.value}</strong></span>
          </div>
        </div>
      `);
    });
    $('.small-card').draggable({ helper: 'clone', cursor: 'move', revert: 'invalid', zIndex: 1000 });
  }

  function initTaskBar($task) {
    $task.draggable({
      containment: $task.parent(),
      grid: [dayWidth, 0],
      cursor: "move",
      start: () => $task.addClass('ring-4 ring-orange-300'),
      stop: () => {
        $task.removeClass('ring-4 ring-orange-300');
        const l = Math.round($task.position().left / dayWidth) * dayWidth;
        $task.css('left', l + 'px');

        const stationId = $task.data('station');
        const taskTitle = $task.data('title');
        const taskValue = $task.data('value');
        updateMetricsRowsPosition(stationId, taskTitle, taskValue);
        updateContextMenuPosition($task);
      },
      drag: () => {
        updateContextMenuPosition($task);
      }
    });

    $task.on('click', function() {
      const stationId = $(this).data('station');
      const taskTitle = $(this).data('title');
      const taskValue = $(this).data('value');
      createMetricsRows(stationId, taskTitle, taskValue);
    });

    $task.on('contextmenu', function(e) {
      e.preventDefault();

      const $t = $(this);
      const existingMenu = $('.task-context-menu');

      if (existingMenu.length > 0) {
        existingMenu.remove();
        return;
      }

      const taskOffset = $t.offset();

      const leftPosition = taskOffset.left - 205;
      const topPosition = taskOffset.top;

      $('.task-context-menu').remove();

      const taskTitle = $t.data('title');
      const taskValue = $t.data('value');
      const stationId = $t.data('station');

      const batchNo = $t.data('batch');
      const isSplitBatch = batchNo !== undefined && batchNo !== null && batchNo !== '';

      const batchSection = isSplitBatch ? `
                    <div class="mt-3 text-xs text-gray-500 font-medium">
                        Batch ${batchNo} /
                    </div>
                    <div class="text-sm text-gray-700 mb-1">
                        Batch Quantity: <span class="font-normal text-gray-800">-</span>
                    </div>
      ` : '';

      const totalsSection = isSplitBatch
        ? `
                    <div class="text-sm text-gray-700">
                        Total Order Quantity: <span class="font-normal text-gray-800">-</span>
                    </div>
                    <div class="text-sm text-gray-700">
                        Latest Start: <span class="font-normal text-gray-800">-</span>
                    </div>
        `
        : `
                    <div class="text-sm font-medium text-gray-700">
                        Total Order Quantity: <span class="font-normal text-gray-800">${taskValue}</span>
                    </div>
        `;

      const $contextMenu = $(`
                <div class="task-context-menu absolute bg-white rounded-lg shadow-lg p-4 w-[220px] border border-gray-200" 
                     style="left: ${leftPosition}px; top: ${topPosition}px; z-index: 9999;">
                    <!-- Title -->
                    <div class="text-gray-900 font-semibold text-sm">
                        ${taskTitle}-Green
                    </div>
                    
                    <!-- Subtitle -->
                    <div class="text-gray-500 text-xs mb-3">
                        Station ${stationId}
                    </div>
                    
                    ${batchSection}

                    <!-- Quantity / Totals -->
                    ${totalsSection}
                    
                    <!-- Divider -->
                    <div class="border-t border-gray-200 my-3"></div>
                    
                    <!-- Split Process -->
                    <div class="flex items-center gap-2 py-1 cursor-pointer hover:bg-gray-50 rounded-md px-1 split-process-btn">
                        <i class="fa-solid fa-bars text-gray-700 text-sm"></i>
                        <span class="text-gray-700 text-sm">Split Process...</span>
                    </div>
                    
                    <!-- Return to Unplanned -->
                    <div class="flex items-center gap-2 py-1 cursor-pointer hover:bg-gray-50 rounded-md px-1 mt-1 return-to-unplanned-btn">
                        <i class="fa-solid fa-rotate-left text-gray-700 text-sm"></i>
                        <span class="text-gray-700 text-sm">Return to Unplanned</span>
                    </div>
                </div>
            `).appendTo('body');

      $('.split-process-btn').on('click', function(ev) {
        ev.preventDefault();
        ev.stopPropagation();
        openSplitModal($t);
        $('.task-context-menu').remove();
      });

      // Return task from Gantt back to Unplanned small cards
      $contextMenu.find('.return-to-unplanned-btn').on('click', function(ev) {
        ev.preventDefault();
        ev.stopPropagation();

        const taskTitle = $t.data('title');
        const taskValue = $t.data('value');
        const taskColor = $t.data('color') || 'bg-blue-100 text-blue-800';

        // Recreate the small card in the Unplanned container
        const $card = $(`
          <div class="${taskColor} rounded-lg p-3 mb-2 cursor-move small-card shadow hover:shadow-md" data-title="${taskTitle}" data-value="${taskValue}" data-color="${taskColor}">
            <div class="flex justify-between text-xs font-medium">
              <span>${taskTitle}</span>
              <span>Qty: <strong>${taskValue}</strong></span>
            </div>
          </div>
        `);

        $('#small-cards-container').append($card);

        // Make the new small card draggable again
        $card.draggable({ helper: 'clone', cursor: 'move', revert: 'invalid', zIndex: 1000 });

        const stationId = $t.data('station');

        // Remove the task bar from the Gantt chart
        $t.remove();

        // Update metrics rows for this station after removal
        updateMetricsRowsPosition(stationId, taskTitle, taskValue);

        // Close the context menu
        $('.task-context-menu').remove();
      });

      $(document).on('click', function closeContextMenu() {
        $('.task-context-menu').remove();
        $(document).off('click', closeContextMenu);
      });
    });
  }

  function openSplitModal($task) {
    selectedTask = $task;
    const widthPx = parseInt($task.css('width')) || 0;
    splitTotalDays = Math.max(0, Math.round(widthPx / dayWidth));

    // Reset batches
    batchCount = 1;
    $('#split-modal .batch-row').not('[data-batch="1"]').remove();
    $('#split-modal .batch-row[data-batch="1"] .batch-input').val(0);

    // Update totals and remainder
    $('#split-original-total').text(splitTotalDays.toFixed(2));
    $('#split-total-entered').text('0.00');
    $('#split-remainder').val(splitTotalDays.toFixed(2));

    $('#split-modal').show();
  }

  function renderGanttRows(processName) {

    const $rows = $('#gantt-rows').empty();
    const totalDaysInYear = getDaysInYear(currentYear);
    const fullWidth = totalDaysInYear * dayWidth;

    (processData[processName]?.stations || []).forEach(station => {
      $rows.append(`
        <div class="grid border-b hover:bg-gray-50" style="grid-template-columns: 200px 1fr; width: ${fullWidth}px;">
            <div class="py-0 pl-4 border-r bg-gray-50 text-sm sticky left-0 z-30" style="position: sticky;">
            <div class="font-bold">${station.name}</div>
            <div class="text-xs text-gray-500">${station.id}</div>
            </div>
            <div class="relative h-[40px] overflow-visible" data-line="${station.id}">
            <div class="task-layer absolute inset-0" style="width:${fullWidth}px;"></div>
            </div>
        </div>
        `);
    });

    // Full year grid lines + weekend shading
    $('.task-layer').each(function() {
        const $layer = $(this);
        $layer.empty();
        for (let i = 0; i < totalDaysInYear; i++) {
        const date = new Date(startDate);
        date.setDate(date.getDate() + i);
        const isWeekend = date.getDay() === 0 || date.getDay() === 6;
        $layer.append(`
            <div class="absolute top-0 border-r ${isWeekend ? 'bg-gray-50' : ''}" 
                style="left:${i * dayWidth}px; width:${dayWidth}px; height:100%; pointer-events:none;"></div>
        `);
        }
    });

    // Droppable with proper ORANGE task bar
    $('.task-layer').droppable({
        accept: '.small-card',
        tolerance: 'pointer',
        drop: function(event, ui) {
        const $layer = $(this);
        const title = ui.draggable.data('title');
        // const value = ui.draggable.data('value');
        const value = 24;
        const color = ui.draggable.data('color') || 'bg-blue-100 text-blue-800';

        const offset = $layer.offset();
        let left = event.clientX - offset.left;
        left = Math.max(0, Math.round(left / dayWidth) * dayWidth);

        const $task = $(`
            <div class="task-bar bg-orange-500 text-white font-medium text-xs rounded-lg shadow-md border-2 border-white flex items-center justify-start cursor-pointer"
                style="left:${left}px; width:${dayWidth * 14}px;" data-station="${$layer.closest('[data-line]').data('line')}" data-title="${title}" data-value="${value}" data-color="${color}">
                <div class="flex" style="width: 20px; height: 100%; position: absolute; left: 0; top: 0;">
                    <div class="flex gap-0.5 flex-col justify-center items-center" style="width: 10px; height: 100%;">
                        <div class="w-1 h-1 bg-gray-200 rounded-full" style="opacity: 0.8"></div>
                        <div class="w-1 h-1 bg-gray-200 rounded-full" style="opacity: 0.8"></div>
                        <div class="w-1 h-1 bg-gray-200 rounded-full" style="opacity: 0.8"></div>
                    </div>
                    <div class="flex gap-0.5 flex-col justify-center items-center" style="width: 10px; height: 100%;">
                        <div class="w-1 h-1 bg-gray-200 rounded-full" style="opacity: 0.8"></div>
                        <div class="w-1 h-1 bg-gray-200 rounded-full" style="opacity: 0.8"></div>
                        <div class="w-1 h-1 bg-gray-200 rounded-full" style="opacity: 0.8"></div>
                    </div>
                </div>
                <span style="margin-left: 24px;">
                 <i class="fa-solid fa-scissors"></i> ${title} - ${value}
                </span>

            </div>
        `).appendTo($layer);

        initTaskBar($task);

        // Remove the original card from small-cards-container
        ui.draggable.remove();
      }
    });
  }

  function updateContextMenuPosition($task) {
    const $contextMenu = $('.task-context-menu');
    if ($contextMenu.length > 0) {
      const taskOffset = $task.offset();

      const leftPosition = taskOffset.left - 205;
      const topPosition = taskOffset.top;

      $contextMenu.css({
        left: leftPosition + 'px',
        top: topPosition + 'px'
      });
    }
  }

  function createMetricsRows(stationId, title, value) {
    const $rows = $('#gantt-rows');
    const totalDaysInYear = getDaysInYear(currentYear);
    const fullWidth = totalDaysInYear * dayWidth;

    // Find the station row and add metrics after it
    const $stationRow = $(`div[data-line="${stationId}"]`).closest('.grid');

    // Check if metrics rows already exist for this station
    const existingMetrics = $(`.metrics-row[data-station="${stationId}"]`);

    if (existingMetrics.length > 0) {
      // Hide existing metrics rows
      existingMetrics.remove();
    } else {
      // Create 4 metrics rows
      const metrics = [
        { name: 'FG OI', value: '1,250', color: 'bg-yellow-100 text-yellow-800' },
        { name: 'Plan Qty', value: value, color: 'bg-purple-100 text-purple-800' },
        { name: 'Efficiency', value: '92%', color: 'bg-green-100 text-green-800' },
        { name: 'PO + FC', value: '85%', color: 'bg-blue-100 text-blue-800' }
      ];

      metrics.forEach((metric, index) => {
        // Find all task bars for this station
        const $taskBars = $(`.task-bar[data-station="${stationId}"]`);

        let metricsCells = '';
        for (let i = 0; i < totalDaysInYear; i++) {
          const date = new Date(startDate);
          date.setDate(date.getDate() + i);
          const isWeekend = date.getDay() === 0 || date.getDay() === 6;

          // Check if this day is covered by ANY bar for this station
          let isInRange = false;
          $taskBars.each(function() {
            const left = parseInt($(this).css('left')) || 0;
            const width = parseInt($(this).css('width')) || (dayWidth * 14);
            const startDay = Math.floor(left / dayWidth);
            const endDay = Math.floor((left + width) / dayWidth);
            if (i >= startDay && i < endDay) {
              isInRange = true;
              return false; // break
            }
          });

          let cellContent = '';
          if (isInRange) {
            if (metric.name === 'Efficiency') {
              cellContent = `
                <div class="flex items-center justify-center h-full">
                  <span class="px-1 py-1 rounded text-xs font-medium bg-white border border-blue-500 outline-none" contenteditable="true">${metric.value}</span>
                </div>
              `;
            } else {
              cellContent = `
                <div class="flex items-center justify-center h-full">
                  <span class="px-1 py-1 rounded text-xs font-medium">${metric.value}</span>
                </div>
              `;
            }
          }

          metricsCells += `
            <div class="border-r ${isWeekend ? 'bg-gray-50' : ''} ${isInRange ? metric.color : ''} relative" 
              style="width:${dayWidth}px; height:30px;">
              ${cellContent}
            </div>
          `;
        }

        const $metricsRow = $(`
          <div class="grid border-b bg-gray-50 metrics-row" data-station="${stationId}" style="grid-template-columns: 200px 1fr; width: ${fullWidth}px;">
            <div class="py-1 pl-4 border-r ${metric.color} text-xs sticky left-0 z-30" style="position: sticky;">
              <div class="font-medium">${metric.name}</div>
            </div>
            <div class="relative h-[30px] flex">
              <div class="flex" style="width: ${fullWidth}px;">
                ${metricsCells}
              </div>
            </div>
          </div>
        `);

        // Insert after the station row
        $stationRow.after($metricsRow);
      });
    }
  }

  function updateMetricsRowsPosition(stationId, title, value) {
    const totalDaysInYear = getDaysInYear(currentYear);
    const fullWidth = totalDaysInYear * dayWidth;

    // Check if metrics rows exist for this station
    const existingMetrics = $(`.metrics-row[data-station="${stationId}"]`);

    if (existingMetrics.length > 0) {
      // Find all task bars for this station
      const $taskBars = $(`.task-bar[data-station="${stationId}"]`);

      // Update each metrics row
      const metrics = [
        { name: 'FG OI', value: '1,250', color: 'bg-yellow-100 text-yellow-800' },
        { name: 'Plan Qty', value: value, color: 'bg-purple-100 text-purple-800' },
        { name: 'Efficiency', value: '92%', color: 'bg-green-100 text-green-800' },
        { name: 'PO + FC', value: '85%', color: 'bg-blue-100 text-blue-800' }
      ];

      existingMetrics.each(function(index) {
        const $metricsRow = $(this);
        const metric = metrics[index];

        let metricsCells = '';
        for (let i = 0; i < totalDaysInYear; i++) {
          const date = new Date(startDate);
          date.setDate(date.getDate() + i);
          const isWeekend = date.getDay() === 0 || date.getDay() === 6;

          // Check if this day is covered by ANY bar for this station
          let isInRange = false;
          $taskBars.each(function() {
            const left = parseInt($(this).css('left')) || 0;
            const width = parseInt($(this).css('width')) || (dayWidth * 14);
            const startDay = Math.floor(left / dayWidth);
            const endDay = Math.floor((left + width) / dayWidth);
            if (i >= startDay && i < endDay) {
              isInRange = true;
              return false; // break
            }
          });

          let cellContent = '';
          if (isInRange) {
            if (metric.name === 'Efficiency') {
              cellContent = `
                <div class="flex items-center justify-center h-full">
                  <span class="px-1 py-1 rounded text-xs font-medium bg-white border border-blue-500 outline-none" contenteditable="true">${metric.value}</span>
                </div>
              `;
            } else {
              cellContent = `
                <div class="flex items-center justify-center h-full">
                  <span class="px-1 py-1 rounded text-xs font-medium">${metric.value}</span>
                </div>
              `;
            }
          }

          metricsCells += `
            <div class="border-r ${isWeekend ? 'bg-gray-50' : ''} ${isInRange ? metric.color : ''} relative" 
              style="width:${dayWidth}px; height:30px;">
              ${cellContent}
            </div>
          `;
        }

        // Update the metrics row content
        $metricsRow.find('.flex').html(metricsCells);
      });
    }
  }

  function switchProcess(name) {
    $('.process-btn').removeClass('bg-gray-200 text-gray-800 rounded').addClass('text-gray-600');
    $(`.process-btn[data-process="${name}"]`).addClass('bg-gray-200 text-gray-800 rounded').removeClass('text-gray-600');
    $('#unplanned-text').text(processData[name]?.unplannedText || '');
    renderSmallCards(name);
    renderGanttRows(name);
  }

  switchProcess('sewing');

  $('.process-btn').on('click', function() { switchProcess($(this).data('process')); });
  $('#prev-year').on('click', () => { currentYear--; updateYear(currentYear); renderGanttRows('sewing'); });
  $('#next-year').on('click', () => { currentYear++; updateYear(currentYear); renderGanttRows('sewing'); });

  $('#header-scroll, #gantt-body').on('scroll', function() {
    $('#header-scroll').scrollLeft(this.scrollLeft);
    $('#gantt-body').scrollLeft(this.scrollLeft);
  });

  // Modal close functionality
  $('#cancel-split').on('click', function() {
    $('#split-modal').hide();
    selectedTask = null;
  });

  // Close modal when clicking outside
  $('#split-modal').on('click', function(e) {
    if (e.target === this) {
      $('#split-modal').hide();
    }
  });

  // Add Batch functionality
  let batchCount = 1;

  $('#add-batch-btn').on('click', function() {
    batchCount++;
    
    // Create new batch row with remove button

    const newBatchRow = $(`
                <div class="grid grid-cols-2 items-center mb-3 px-1 batch-row" data-batch="${batchCount}">
                    
                    <!-- Batch Label -->
                    <span class="text-gray-700 text-sm">Batch ${batchCount}</span>

                    <!-- Input with minus button inside -->
                    <div class="relative w-full">
                        <input
                            type="number"
                            value="0"
                            class="border rounded-md px-3 pr-8 py-2 text-sm w-full
                                focus:ring-1 focus:ring-blue-400 focus:border-blue-400 batch-input"
                        />

                        <!-- Minus button INSIDE input -->
                        <button
                            class="absolute bg-red-100 rounded right-2 top-1/2 -translate-y-1/2 text-red-500 hover:text-red-700 text-sm remove-batch-btn"
                        >
                            <i class="fa-solid fa-minus"></i>
                        </button>
                    </div>

                </div>

    `);
    
    // Insert before the remainder row - find the remainder row and insert before it
    $('#split-remainder').parent().before(newBatchRow);
    
    // Add input change handler to update remainder

    $('.batch-input').off('input').on('input', updateRemainder);
    
    // Add remove button handler
    $('.remove-batch-btn').off('click').on('click', function() {
      $(this).closest('.batch-row').remove();
      updateRemainder();
    });
    
    updateRemainder();
  });

  // Update remainder when batch inputs change
    function updateRemainder() {
        let totalBatchDays = 0;

        $('#split-modal .batch-input').each(function() {
            totalBatchDays += parseFloat($(this).val()) || 0;
        });

        const remainder = (splitTotalDays - totalBatchDays).toFixed(2);

        $('#split-remainder').val(remainder);
        $('#split-total-entered').text(totalBatchDays.toFixed(2));
    }


  // Initialize with first batch input handler
  $('.batch-input').on('input', updateRemainder);

  $('#confirm-split').on('click', function() {
    if (!selectedTask) {
      $('#split-modal').hide();
      return;
    }

    let batches = [];
    let totalBatchDays = 0;

    $('#split-modal .batch-input').each(function() {
      const v = parseFloat($(this).val()) || 0;
      if (v > 0) {
        batches.push(v);
        totalBatchDays += v;
      }
    });

    if (batches.length === 0) {
      return;
    }

    if (Math.round(totalBatchDays * 100) / 100 !== Math.round(splitTotalDays * 100) / 100) {
      return;
    }

    const originalLeft = parseInt(selectedTask.css('left')) || 0;
    const stationId = selectedTask.data('station');
    const title = selectedTask.data('title');
    const value = selectedTask.data('value');
    const $layer = selectedTask.parent();

    let offsetDays = 0;

    batches.forEach((days, index) => {
      const left = originalLeft + offsetDays * dayWidth;
      const width = days * dayWidth;

      const $newTask = selectedTask.clone();
      $newTask.css({ left: left + 'px', width: width + 'px' });
      $newTask.attr('data-batch', index + 1);
      $newTask.find('span').html(`<i class="fa-solid fa-scissors"></i> ${title} - ${value}`);
      $newTask.appendTo($layer);
      initTaskBar($newTask);

      offsetDays += days;
    });

    selectedTask.remove();
    selectedTask = null;
    $('#split-modal').hide();
  });
});

</script>



</body>
</html>